require( "scripts/style.lua" );



TitleFont = {
  standardFont,
  70,
  BlackColor
};

MedalFont = {
  standardFont,
  20,
  BlackColor
};


function UpdateSubmit()
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);
	EnableWindow('submit', fullHS and NumMedalsToSubmit() > 0);
end


function DoMedal(medalName, gameMode, posX, posY, descrip)
	numMedals = NumEarnedMedals();
	medalimage = "hiscore/medal_unearned";
	for i=0,numMedals-1 do
		if (GetMedalName(i) == medalName and
			(gameMode == nil or gameMode == GetMedalGameMode(i))) then
			medalimage="hiscore/medal_earned";
			break;
		end
	end
	return Group
	{
		Bitmap
		{
			image=medalimage,
			x = posX,
			y = posY,
			
			RolloverWindow
			{
				x=0,y=0,w=kMax,h=kMax,
				activate = 'medaldescrip',
				text = descrip;
			};
		}
	};
	
end
function MakeMedals()
	local windows = {};
	table.insert(windows, DoMedal(GetPFMedalName(0), GetPFGameModeName(0), 130, 200, GetString('medaldescrip1'))); 
	table.insert(windows, DoMedal(GetPFMedalName(1), GetPFGameModeName(0), 270, 200, GetString('medaldescrip2')));
	table.insert(windows, DoMedal(GetPFMedalName(2), GetPFGameModeName(0), 410, 200, GetString('medaldescrip3')));
	table.insert(windows, DoMedal(GetPFMedalName(3), GetPFGameModeName(0), 550, 200, GetString('medaldescrip4'))); 
	table.insert(windows, DoMedal(GetPFMedalName(4), GetPFGameModeName(0), 200, 350, GetString('medaldescrip5')));
	table.insert(windows, DoMedal(GetPFMedalName(5), GetPFGameModeName(0), 350, 350, GetString('medaldescrip6')));
	table.insert(windows, DoMedal(GetPFMedalName(6), GetPFGameModeName(1), 500, 350, GetString('medaldescrip7')));
	return Group(windows);
end

vHSButtonFontStyle = { standardFont, 16, BlackColor };

vHSButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}

MakeDialog
{
	-- Name the modal dialog
	name="medalswindow",
	Bitmap
	{
		image="backgrounds/fullscreendialog",

			
		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=30,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "medals",
		};

		SetStyle(ButtonStyle),
		MakeMedals(),
		
		Text
		{
			font = MedalFont,
			x = 0,
			y = 500,
			h = 100,
			w = kMax,
			flags = kHAlignCenter + kVAlignTop,
			name = 'medaldescrip',
			
			
		};
		
		Button
		{
			x=kCenter + 100,
			y=kMax-40,
			name="submit",
			type = kPush,
			flags = kHAlignCenter + kVAlignCenter,
			label="submit",
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			command =
				function()
					gMedalsMode = true;
					vars = loadstring(GetLuaServerSubmitSetupVars(true));
					vars();
					val = DoModal("scripts/serversubmit.lua");
					if (val == 'success') then
						DisplayDialog {
							"scripts/ok.lua",
							body ="medalsuccess",
							title = ""
						};
					end
					UpdateSubmit();
				end
		};

		Button
		{
			x=kCenter - 100,
			y=kMax-40,
			name="back",
			type = kPush,
			flags = kHAlignCenter + kVAlignCenter,
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			label="back",
			command =
				function()
					PopModal("medalswindow"); 
				end
		};
		
	}
}

UpdateSubmit();